#ifndef USER_JOURNAL_PARAMETERS_GET_PARAM_TYPES_H_
#define USER_JOURNAL_PARAMETERS_GET_PARAM_TYPES_H_

#include <type_traits>
#include <tuple>

namespace user_journal {
namespace parameters {
namespace details {

template<typename... Types>
struct TypeList {};

template<typename... Types>
struct MergeTypes;

template<typename... Types1, typename... Types2>
struct MergeTypes<TypeList<Types1...>, TypeList<Types2...>> {
    using type = TypeList<Types1..., Types2...>;
};

template<typename... Types>
struct GetParamTypes;

template<typename Type>
struct UnpackParams {
    using type = TypeList<Type>;
};

template<typename... Types>
struct UnpackParams<std::tuple<Types...>> {
    using type = typename GetParamTypes<Types...>::type;
};

template<>
struct GetParamTypes<> {
    using type = TypeList<>;
};

template<typename Head, typename... Tail>
struct GetParamTypes<Head, Tail...> {
    using Param = typename std::decay<Head>::type;
    using type = typename MergeTypes<typename UnpackParams<Param>::type, typename GetParamTypes<Tail...>::type>::type;
};

} // namespace details
} // namespace parameters
} // namespace user_journal


#endif /* USER_JOURNAL_PARAMETERS_GET_PARAM_TYPES_H_ */
