#ifndef USER_JOURNAL_PARAMETERS_IS_ONE_OF_H
#define USER_JOURNAL_PARAMETERS_IS_ONE_OF_H

#include <type_traits>
#include <boost/optional.hpp>

namespace user_journal {
namespace parameters {
namespace details {

template <typename T, typename... Args> struct IsOneOf;
template <typename T, typename U> struct Comparator {
    static constexpr bool isOneOf = false;
};

template <typename T>
struct IsOneOf<T> {
    static constexpr bool value = false;
};

template <typename T, typename U, typename... Args>
struct IsOneOf<T, U, Args...> {
    typedef typename std::decay<U>::type CurrentArg;
    static constexpr bool value = Comparator<T, CurrentArg>::isOneOf || IsOneOf<T, Args...>::value;
};

template <typename T>
struct Comparator<T, T> {
    static constexpr bool isOneOf = true;
};

template <typename T, typename... TupleArgs>
struct Comparator<T, std::tuple<TupleArgs...>> {
    static constexpr bool isOneOf = IsOneOf<T, TupleArgs...>::value;
};

} // namespace details
} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_IS_ONE_OF_H */
