#ifndef USER_JOURNAL_PARAMETERS_LABELS_H
#define USER_JOURNAL_PARAMETERS_LABELS_H

#include <user_journal/parameters/operation_parameters.h>

namespace user_journal {
namespace parameters {

template <Operation::Enum operationT, typename ... Args>
using LabelsParams = OperationParameters<Target::labels, operationT, Args...>;

using CreateLabel = LabelsParams<Operation::create,
        id::lid,
        id::labelName,
        id::labelType,
        id::labelSymbol,
        id::labelColor>;

using RenameLabel = LabelsParams<Operation::rename,
        id::lid,
        id::labelName,
        id::labelColor>;

using DeleteLabel = LabelsParams<Operation::deletee,
        id::lid>;

using ClearLabel = LabelsParams<Operation::clear,
        id::lid>;

} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_LABELS_H */
