#pragma once

#include <user_journal/parameters/operation_parameters.h>

namespace user_journal::parameters {

template <Operation::Enum operationT, typename ... Args>
using MailBoxParams = OperationParameters<Target::mailbox, operationT, Args...>;

using SendMessage = MailBoxParams<Operation::send,
        id::msgId,
        id::mid,
        id::emailTo,
        id::emailCc,
        id::emailBcc>;

using UndoSending = MailBoxParams<Operation::undo_sending, id::mid>;

using ResetFresh = MailBoxParams<Operation::reset_fresh>;

} // namespace user_journal::parameters
