#ifndef USER_JOURNAL_PARAMETERS_MANDATORY_PARAMS_H_
#define USER_JOURNAL_PARAMETERS_MANDATORY_PARAMS_H_

#include <boost/optional.hpp>
#include <user_journal/parameters/is_one_of.h>

namespace user_journal {
namespace parameters {

template <typename T>
struct Mandatory : public std::true_type {};

template <typename T>
struct Mandatory<boost::optional<T>> : public std::false_type {};

template<typename... Params>
struct HasAllMandatoryParams {
    template<typename... ArgsT>
    static constexpr bool value() { return true; }
};

template<typename Head, typename... Tail>
struct HasAllMandatoryParams<Head, Tail...> {
    template<typename... ArgsT>
    static constexpr bool value() {
        return (!Mandatory<Head>::value || details::IsOneOf<Head, ArgsT...>::value) &&
                HasAllMandatoryParams<Tail...>::template value<ArgsT...>();
    }
};

} // namespace parameters
} // namespace user_journal


#endif /* USER_JOURNAL_PARAMETERS_MANDATORY_PARAMS_H_ */
