#pragma once

#include <user_journal/parameters/operation_parameters.h>

namespace user_journal {
namespace parameters {

template <Operation::Enum operationT, typename ... Args>
using MessageParams = OperationParameters<Target::message, operationT, Args...>;

using AbuseMessage = MessageParams<Operation::abuse,
        id::mids,
        id::abuseType>;

using CreateMessage = MessageParams<Operation::create,
        id::mid>;

using UpdateMessage = MessageParams<Operation::create,
        id::oldMid,
        id::newMid>;

using TrashMessages = MessageParams<Operation::trash,
        id::mids>;

using MoveMessages = MessageParams<Operation::move,
        id::mids,
        id::destFid>;

using CopyMessages = MessageParams<Operation::copy,
        id::mids,
        id::destFid>;

using DeleteMessages = MessageParams<Operation::deletee,
        id::mids>;

using MarkMessages = MessageParams<Operation::mark,
        id::mids,
        id::msgStatus>;

using ReceiveMessage = MessageParams<Operation::receive,
        id::fid,
        id::mid,
        id::tid,
        id::stid,
        id::ftype,
        id::emailFrom,
        id::labelSymbols,
        id::filterIds,
        id::subject,
        id::msgId,
        id::emailTo,
        id::emailCc,
        id::phone>;

using AddLabels = MessageParams<Operation::label,
        id::mids,
        id::lids,
        id::labelTypes,
        id::labelSymbols>;

using RemoveLabels = MessageParams<Operation::unlabel,
        id::mids,
        id::lids,
        id::labelTypes,
        id::labelSymbols>;

using AddLabelsByThreads = MessageParams<Operation::label,
        id::tids,
        id::lids,
        id::labelTypes,
        id::labelSymbols>;

using RemoveLabelsByThreads = MessageParams<Operation::unlabel,
        id::tids,
        id::lids,
        id::labelTypes,
        id::labelSymbols>;

using MoveMessagesToTab = MessageParams<Operation::move_to_tab,
        id::mids,
        id::destTab>;

using ChangeTab = MessageParams<Operation::change_so_type,
        id::mid,
        id::stid,
        id::receivedDate,
        id::srcTab,
        id::destTab>;

} // namespace parameters
} // namespace user_journal
