#ifndef USER_JOURNAL_PARAMETERS_OPERATION_PARAMETERS_H
#define USER_JOURNAL_PARAMETERS_OPERATION_PARAMETERS_H

#include <user_journal/parameters/parameters.h>
#include <user_journal/parameters/parameter_id.h>
#include <user_journal/date.h>

namespace user_journal {
namespace parameters {

using IdHidden = boost::optional<id::hidden>;

template <Target::Enum targetT, Operation::Enum operationT, typename... ParamsT>
struct OperationParameters : Parameters<IdHidden, id::mdb, id::state, id::affected, ParamsT...> {
    using Base = Parameters<IdHidden, id::mdb, id::state, id::affected, ParamsT...>;

    void map(const Mapper & m) const {
        m.mapValue(target(), "target");
        m.mapValue(operation(), "operation");
        m.mapValue(date(), "date");
        m.mapValue(unixtime(date()), "unixtime");
        Base::map(m);
    }

    static Operation operation() {
        return operationT;
    }

    static Target target() {
        return targetT;
    }

    const Date& date() const {
        return date_;
    }

    template<typename... ArgsT>
    OperationParameters(ArgsT&& ... args) : Base(std::forward<ArgsT>(args)... ), date_(currentDate()) {
        checkHasMandatoryParams<ArgsT...>();
    }

    OperationParameters(OperationParameters &&) = default;
    OperationParameters(const OperationParameters &) = default;

private:
    Date date_;

    template<typename... ArgsT>
    void checkHasMandatoryParams() {
        static_assert(HasAllMandatoryParams<IdHidden, id::mdb, id::state, id::affected,
                ParamsT...>::template value<ArgsT...>(),
                "Missing mandatory parameter");
    }
};

} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_OPERATION_PARAMETERS_H */
