#pragma once

#include <user_journal/parameters/wrapper.h>
#include <user_journal/mapper.h>

namespace user_journal {
namespace parameters {
namespace id {

template <typename Tag>
struct ValueWrapper {
    using Value = typename Tag::Value;
    Value value;
    template <typename... ArgsT>
    explicit ValueWrapper(ArgsT&& ... args) : value(std::forward<ArgsT>(args)...) {}
};

#define DECLARE_PARAMETER_ID_EXT( className, idName, type ) \
        struct className##Tag { typedef type Value; };\
        using className = ValueWrapper<className##Tag>;\
        \
        template<>\
        struct Wrapper<className> {\
            void map(const Mapper & m) const { m.mapValue(v_.value, idName); }\
            void set(const className & v) { v_ = v; }\
        private:\
            className v_;\
        };\
        \
        template<>\
        struct Wrapper<boost::optional<className>> {\
            void map(const Mapper & m) const {\
                if (v_) { m.mapValue(v_->value, idName); } \
            }\
            void set(const className & v) { v_ = v; }\
        private:\
            boost::optional<className> v_;\
        }

#define DECLARE_PARAMETER_ID( idName, type ) \
        DECLARE_PARAMETER_ID_EXT( idName, #idName, type )


DECLARE_PARAMETER_ID( mdb, std::string );
DECLARE_PARAMETER_ID( hidden, bool );
DECLARE_PARAMETER_ID( state, std::string );
DECLARE_PARAMETER_ID( affected, std::size_t);
DECLARE_PARAMETER_ID( mid, std::string );
DECLARE_PARAMETER_ID( oldMid, std::string );
DECLARE_PARAMETER_ID( newMid, std::string );
DECLARE_PARAMETER_ID( msgStatus, std::string );
DECLARE_PARAMETER_ID( fid, std::string );
DECLARE_PARAMETER_ID( parentFid, std::string );
DECLARE_PARAMETER_ID( folderName, std::string );
DECLARE_PARAMETER_ID( folderType, std::string );
DECLARE_PARAMETER_ID( folderSymbol, std::string );
DECLARE_PARAMETER_ID( ftype, int );
DECLARE_PARAMETER_ID( tid, std::string );
DECLARE_PARAMETER_ID( stid, std::string );
DECLARE_PARAMETER_ID( lid, std::string );
DECLARE_PARAMETER_ID( labelName, std::string );
DECLARE_PARAMETER_ID( labelType, std::string );
DECLARE_PARAMETER_ID( labelSymbol, std::string );
DECLARE_PARAMETER_ID( labelColor, std::string );
DECLARE_PARAMETER_ID( srcFid, std::string );
DECLARE_PARAMETER_ID( destFid, std::string );
DECLARE_PARAMETER_ID( abuseType, std::string );
DECLARE_PARAMETER_ID( mids, std::vector<std::string> );
DECLARE_PARAMETER_ID( fids, std::vector<std::string> );
DECLARE_PARAMETER_ID( lids, std::vector<std::string> );
DECLARE_PARAMETER_ID( tids, std::vector<std::string> );
DECLARE_PARAMETER_ID( labelSymbols, std::vector<std::string> );
DECLARE_PARAMETER_ID( labelTypes, std::vector<std::string> );
DECLARE_PARAMETER_ID( filterIds, std::vector<std::string> );

DECLARE_PARAMETER_ID( emailTo, std::string );
DECLARE_PARAMETER_ID( emailCc, std::string );
DECLARE_PARAMETER_ID( emailBcc, std::string );
DECLARE_PARAMETER_ID( emailFrom, std::string );
DECLARE_PARAMETER_ID( msgId, std::string );
DECLARE_PARAMETER_ID( subject, std::string );

DECLARE_PARAMETER_ID( ip, std::string );
DECLARE_PARAMETER_ID( module, std::string );
DECLARE_PARAMETER_ID( regionId, int );
DECLARE_PARAMETER_ID( yandexuidCookie, std::string );
DECLARE_PARAMETER_ID( iCookie, std::string );
DECLARE_PARAMETER_ID( suid, std::string );
DECLARE_PARAMETER_ID( connectionId, std::string );
DECLARE_PARAMETER_ID( sessionInfo, std::string );
DECLARE_PARAMETER_ID( internetProvider, std::string );
DECLARE_PARAMETER_ID( clientType, std::string );
DECLARE_PARAMETER_ID( clientVersion, std::string );
DECLARE_PARAMETER_ID( userAgent, std::string );
DECLARE_PARAMETER_ID( requestId, std::string );

DECLARE_PARAMETER_ID_EXT( testBuckets, "test-buckets", std::string );
DECLARE_PARAMETER_ID_EXT( enabledTestBuckets, "enabled-test-buckets", std::string );

DECLARE_PARAMETER_ID( settingName, std::string );
DECLARE_PARAMETER_ID( settingValue, std::string );
DECLARE_PARAMETER_ID( phone, std::string );

DECLARE_PARAMETER_ID( removeSoTypes, std::vector<std::string> );
DECLARE_PARAMETER_ID( addSoTypes, std::vector<std::string> );
DECLARE_PARAMETER_ID( receivedDate, std::string );

DECLARE_PARAMETER_ID( tab, std::string );
DECLARE_PARAMETER_ID( srcTab, std::string );
DECLARE_PARAMETER_ID( destTab, std::string );

DECLARE_PARAMETER_ID( replyLaterDate, std::time_t );
DECLARE_PARAMETER_ID( stickerSymbol, std::string );

#undef DECLARE_PARAMETER_ID
#undef DECLARE_PARAMETER_ID_EXT


struct operationSystem {
    std::string name;
    std::string version;
};

template<>
struct Wrapper<operationSystem> {
    void map(const Mapper & m) const {
        m.mapValue(v_.name, "operationSystem.name");
        m.mapValue(v_.version, "operationSystem.version");
    }
    void set(const operationSystem & v) {
        v_ = v;
    }
private:
    operationSystem v_;
};

struct browser {
    std::string name;
    std::string version;
};

template<>
struct Wrapper<browser> {
    void map(const Mapper & m) const {
        m.mapValue(v_.name, "browser.name");
        m.mapValue(v_.version, "browser.version");
    }
    void set(const browser & v) {
        v_ = v;
    }
private:
    browser v_;
};

} // namespace id
} // namespace parameters
} // namespace user_journal
