#ifndef USER_JOURNAL_PARAMETERS_PARAMETERS_H
#define USER_JOURNAL_PARAMETERS_PARAMETERS_H

#include <user_journal/mapper.h>
#include <user_journal/parameters/wrapper.h>
#include <user_journal/parameters/mandatory_params.h>

namespace user_journal {
namespace parameters {

template<typename... Args>
struct Composer;

template<typename Head, typename... Tail>
struct Composer<Head, Tail...> : id::Wrapper<Head>, Composer<Tail...> {
    using This = id::Wrapper<Head>;
    using Next = Composer<Tail...> ;
    using This::set;
    using Next::set;

    void map(const Mapper & m) const {
        This::map(m);
        Next::map(m);
    }
};

template<>
struct Composer<> {
    void map(const Mapper & ) const {}

    void set() const {}
};

template <typename Base, typename... Params>
struct Parameters : Composer<Base, Params...> {
    using ParamComposer = Composer<Base, Params...>;

    void map(const Mapper & m) const {
        ParamComposer::map(m);
    }

    template<typename... ArgsT>
    Parameters(ArgsT&& ... args) {
        fill(std::forward<ArgsT>(args)...);
    }

    Parameters(Parameters &&) = default;
    Parameters(const Parameters &) = default;
private:
    template<typename FirstArg, typename... ArgsT>
    void fill(FirstArg&& head, ArgsT&& ... args) {
        this->set(std::forward<FirstArg>(head));
        fill(std::forward<ArgsT>(args)...);
    }

    void fill() {}

    template<typename... TupleArgs, typename... ArgsT>
    void fill(const std::tuple<TupleArgs...>& tuple, ArgsT&& ... args) {
        fillWithTuple(tuple, std::forward<ArgsT>(args)...);
    }

    template<typename... TupleArgs, typename... ArgsT>
    void fill(std::tuple<TupleArgs...>& tuple, ArgsT&& ... args) {
        fillWithTuple(tuple, std::forward<ArgsT>(args)...);
    }

    template<typename... TupleArgs, typename... ArgsT>
    void fill(std::tuple<TupleArgs...>&& tuple, ArgsT&& ... args) {
        fillWithTuple(std::move(tuple), std::forward<ArgsT>(args)...);
    }

    template<typename TupleT, typename... ArgsT>
    void fillWithTuple(TupleT&& tuple, ArgsT&& ... args) {
        typedef typename std::decay<TupleT>::type Tuple;
        callFill( typename std::make_index_sequence<std::tuple_size<Tuple>::value>(),
                std::forward<TupleT>(tuple), std::forward<ArgsT>(args)...);
    }

    template<std::size_t ...Is, typename TupleT, typename... ArgsT>
    void callFill(std::index_sequence<Is...>, TupleT&& tuple, ArgsT&& ... args) {
        fill(std::get<Is>(std::forward<TupleT>(tuple))..., std::forward<ArgsT>(args)...);
    }
};

} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_PARAMETERS_H */
