#ifndef USER_JOURNAL_PARAMETERS_REQUEST_PARAMETERS_H
#define USER_JOURNAL_PARAMETERS_REQUEST_PARAMETERS_H

#include <user_journal/parameters/parameters.h>
#include <user_journal/parameters/parameter_id.h>


namespace user_journal {
namespace parameters {

struct RequestParameters {
    virtual ~RequestParameters() = default;
    virtual void map(const Mapper & m) const = 0;
    virtual const std::string& uid() const = 0;
};

typedef std::shared_ptr<RequestParameters> RequestParametersPtr;

template <typename... ParamsT>
struct RequestParametersImpl : public RequestParameters, public Parameters<ParamsT...> {
    using Base = Parameters<ParamsT...>;

    template<typename... ArgsT>
    RequestParametersImpl(const std::string& uid, ArgsT&& ... args) :
            Base(std::forward<ArgsT>(args)... ), uid_(uid) {
        checkHasMandatoryParams<ArgsT...>();
    }

    virtual void map(const Mapper & m) const override {
        Base::map(m);
    }
    virtual const std::string& uid() const override {
        return uid_;
    }

    RequestParametersImpl(RequestParametersImpl &&) = default;
    RequestParametersImpl(const RequestParametersImpl &) = default;

private:
    std::string uid_;

    template<typename... ArgsT>
    void checkHasMandatoryParams() {
        static_assert(HasAllMandatoryParams<id::module>::template value<ArgsT...>(),
                "Missing mandatory parameter");
    }
};

} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_REQUEST_PARAMETERS_H */
