#pragma once

#include <user_journal/parameters/operation_parameters.h>

namespace user_journal::parameters {

template <Operation::Enum operationT, typename ... Args>
using StickersParams = OperationParameters<Target::stickers, operationT, Args...>;

using CreateReplyLaterSticker = StickersParams<Operation::create,
        id::mid,
        id::fid,
        id::tab,
        id::replyLaterDate,
        id::stickerSymbol>;

using RemoveSticker = StickersParams<Operation::deletee,
        id::mid,
        id::stickerSymbol>;

}
