#ifndef PROFILING_H_144507122013
#define PROFILING_H_144507122013

#include <string>
#include <boost/shared_ptr.hpp>
#include <boost/chrono/system_clocks.hpp>

namespace user_journal {
namespace profiling {

namespace details {
using namespace boost::chrono;
typedef time_point<system_clock, milliseconds> Time;
typedef Time::duration Duration;
} // namespace details

typedef details::Time Time;
typedef details::Duration Duration;

class Log {
public:
    virtual ~Log() {};
    virtual void write( const std::string & operation,
            const std::string & info, Duration duration ) = 0;
};

typedef boost::shared_ptr<Log> LogPtr;

} // namespace profiling
} // namespace user_journal

#endif /* PROFILING_H_144507122013 */
