#ifndef USER_JOURNAL_SERVICE_H
#define USER_JOURNAL_SERVICE_H

#include <user_journal/journal.h>
#include <user_journal/parameters/get_param_types.h>

namespace user_journal {

struct Service {
    virtual ~Service() = default;

    template <typename ... ArgsT>
    Journal createJournal(const std::string &uid, ArgsT&& ... args) const {
        auto requestInfo = makeRequestParameters(
                typename parameters::details::GetParamTypes<ArgsT...>::type(),
                uid, std::forward<ArgsT>(args)...);
        return Journal(requestInfo, writer());
    }

protected:
    virtual WriterPtr writer() const = 0;

private:
    template <typename ... ParamsT, typename ... ArgsT>
    parameters::RequestParametersPtr makeRequestParameters(
            parameters::details::TypeList<ParamsT...>,
            const std::string &uid, ArgsT&& ... args) const {
        return std::make_shared<typename parameters::RequestParametersImpl<ParamsT...>>(
                uid, std::forward<ArgsT>(args)...);
    }
};

typedef std::shared_ptr<Service> ServicePtr;

} // namespace user_journal

#endif /* USER_JOURNAL_SERVICE_H */
