#ifndef TARGET_H_160528052013
#define TARGET_H_160528052013

#include <user_journal/enumeration.h>

namespace user_journal {

struct __Target{
    enum Enum {
        unknown,
        message,
        mailbox,
        folders,
        labels,
        account,
        settings,
        stickers,
    };
    typedef Enum2String<Enum>::Map Map;
    void fill(Map & map) const{
#define ADD_ENUM_TO_MAP(name, map) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(unknown, map);
        ADD_ENUM_TO_MAP(message, map);
        ADD_ENUM_TO_MAP(mailbox, map);
        ADD_ENUM_TO_MAP(folders, map);
        ADD_ENUM_TO_MAP(labels, map);
        ADD_ENUM_TO_MAP(account, map);
        ADD_ENUM_TO_MAP(settings, map);
        ADD_ENUM_TO_MAP(stickers, map);
#undef ADD_ENUM_TO_MAP
    }
    typedef __Target Filler;
};

typedef Enumeration<__Target> Target;
}

#endif /* TARGET_H_160528052013 */
