#ifndef USER_JOURNAL_WRITER_H
#define USER_JOURNAL_WRITER_H

#include <user_journal/entry.h>
#include <boost/shared_ptr.hpp>
#include <string>

namespace user_journal {

/**
 * interface for writing user history
 */
struct Writer {
    virtual ~Writer() = default;
    /**
     * Puts user history entry into the storage. User is specified by uid.
     */
    virtual void write(const std::string & uid, const Entry & entry) const = 0;
};

typedef std::shared_ptr<Writer> WriterPtr;

} // namespace user_journal

#endif /* USER_JOURNAL_WRITER_H */
