#include <boost/make_shared.hpp>
#include <internal/async_service.h>
#include <internal/async_writer.h>

namespace user_journal {

AsyncService::AsyncService(const AsyncConnectionInfo & c )
: accessTraits(c.profiler, c.logger, c.tableName, c.tskvFormat),
  queue(boost::make_shared<MutationsQueueImpl>(c.writeChunkSize)),
  sender(queue, c.logger, c.writePollTimeout, c.onSenderThreadException,
         c.fileWriter),
  locale(c.locale){
}

WriterPtr AsyncService::writer() const {
    return std::make_shared<AsyncWriter>(queue, accessTraits, locale);
}

} // namespace user_journal
