#include <user_journal/connection_info.h>
#include <internal/log_exception.h>

namespace user_journal {

const profiling::LogPtr noProfiling;
const logging::LogPtr noLogging;
const ExceptionHandlerPtr defaultExceptionHandler;
const ExceptionHandlerPtr cerrExceptionHandler(new CerrLogException());

ExceptionHandlerPtr logSenderException(logging::LogPtr logger) {
    return ExceptionHandlerPtr(new LogException(logger, "MutationsSender::poll()"));
}

}// namespace user_journal

