#include <internal/misc.h>

#include <boost/lexical_cast.hpp>
#include <sstream>
#include <iomanip>
#include <limits>

namespace user_journal {

const unsigned int uidWidth = 20;

std::string key( const std::string & uid ){
    std::ostringstream s;
    try {
        s << std::setw(uidWidth) << std::setfill('0')
            << boost::lexical_cast<unsigned long>(uid);
    } catch( const boost::bad_lexical_cast & ) {
        throw std::runtime_error(std::string("Bad uid='") + uid + "' cast to int");
    }
    return s.str();
}

}// namespace user_journal

