#include <internal/mutations_queue.h>
#include <boost/thread/lock_guard.hpp>

namespace user_journal {

bool MutationsQueueAlgo::add( TskvRow rows ) const {
    if( currentChunkMaxSizeExceeded() ) {
        if(maxQueueSizeExceeded()) {
            return false;
        } else {
            startNewChunk();
        }
    }
    currentChunk().emplace_back(std::move(rows));
    return true;
}

bool MutationsQueueAlgo::get( TskvRowsChunk& chunk ) const {
    std::swap(chunk, chunks.front());
    chunks.pop();
    if( chunks.empty() ) {
        startNewChunk();
        return false;
    }
    return true;
}

bool MutationsQueueImpl::add( TskvRow rows ) {
    boost::lock_guard<boost::mutex> lock(mutex);
    return algorithm.add(std::move(rows));
}

bool MutationsQueueImpl::get( TskvRowsChunk& chunk ) {
    boost::lock_guard<boost::mutex> lock(mutex);
    return algorithm.get(chunk);
}

}// namespace user_journal
