#include <internal/mutations_sender.h>

#include <internal/logging.h>
#include <internal/profiling.h>
#include <boost/range/algorithm/for_each.hpp>
#include <yplatform/tskv/iomanip.h>

namespace user_journal {

void MutationsSender::poll() const {
    TskvRowsChunk chunk;
    bool hasMoreChunks = false;
    do {
        hasMoreChunks = queue->get(chunk);
        if( !chunk.empty() ) {
            send(chunk);
            chunk.clear();
        }
    } while (hasMoreChunks);
}

void MutationsSender::send( const TskvRowsChunk& chunk) const {
    logging::call([&]{
        boost::for_each(chunk, [&](auto& row) { fileWriter(row); });
    }, logger, "MutationsSender::dump", emptyUid);
}

const std::string MutationsSender::emptyUid;

} // namespace user_journal

