#include <internal/mutations_sender_thread.h>

#include <internal/logging.h>
#include <internal/profiling.h>

namespace user_journal {

void MutationsSenderThread::Poll::operator() () const {
    using namespace boost::this_thread;
    profiling::Duration consumed(0);
    while(!interruption_requested()) {
        if(consumed < timeout) {
            sleep_for(timeout-consumed);
        }
        using namespace boost;
        const profiling::Time start(currentDate());
        try {
            sender.poll();
        } catch ( const std::exception & e ) {
            exceptionHandler->handle(e);
        } catch (...) {
            exceptionHandler->handleUnknown();
        }
        consumed = currentDate().time_since_epoch() - start.time_since_epoch();
    }
}

MutationsSenderThread::MutationsSenderThread(MutationsQueuePtr queue,
            logging::LogPtr logger, Milliseconds timeout,
            ExceptionHandlerPtr exceptionHandler, FileWriter fileWriter)
: sender(queue, logger, fileWriter),
  thread(Poll(sender, timeout, exceptionHandler)){
}

MutationsSenderThread::~MutationsSenderThread() {
    thread.interrupt();
    thread.join();
}

} // namespace user_journal
