#ifndef UTILS_EXCEPTION_HANDLER_H_110216102014
#define UTILS_EXCEPTION_HANDLER_H_110216102014

#include <user_journal/hbase.h>

class ExceptionHandler : public user_journal::hbase::ExceptionHandler {
public:
    virtual void handle( const std::exception & e ) const {
        std::cerr << "Exception: " << e.what() << std::endl;
    }
    virtual void handleUnknown() const {
        std::cerr << "Unknown exception" << std::endl;
    }
    typedef user_journal::hbase::ExceptionHandlerPtr Ptr;
    static Ptr create() {
        return Ptr(new ExceptionHandler());
    }
};

#endif /* UTILS_EXCEPTION_HANDLER_H_110216102014 */
