#ifndef UTILS_PROMPT_H_111423102014
#define UTILS_PROMPT_H_111423102014

#include <iostream>
#include <string>
#include <boost/lexical_cast.hpp>

template <typename T>
T & prompt( const std::string & message, T & value, const T & defaultValue) {
    std::cout << message << '[' << defaultValue << "]:";
    std::string buf;
    std::getline(std::cin,buf);
    value = buf.empty() ? defaultValue : boost::lexical_cast<T>(buf);
    return value;
}



#endif /* UTILS_PROMPT_H_111423102014 */
