#include <user_journal/hbase.h>
#include <user_journal/entry_ostream.h>
#include "exception_handler.h"
#include "prompt.h"
#include <iterator>
#include <functional>
#include <iostream>

using namespace user_journal;

void writeFile( const std::string & buf ) {
    std::cout << buf << std::endl;
}


int main( int argc, char * argv[] ) {
    if( argc < 2 ) {
        return -1;
    }
    try {
        const std::string uid = argv[1];
        hbase::ServiceFactory f;
        f.onSenderThreadException(ExceptionHandler::create());
        f.fileWriter(&writeFile);
        ServicePtr service = f.product();
        Entry entry;
        entry.date = currentDate();
        prompt("ip", entry.ip, entry.ip);
        prompt("module", entry.module, entry.module);
        prompt("target", entry.target, entry.target);
        prompt("operation", entry.operation, entry.operation);
        prompt("state", entry.state, entry.state);
        prompt("affected", entry.affected, entry.affected);
        prompt("hidden", entry.hidden, entry.hidden);
        prompt("clientType", entry.clientType, entry.clientType);
        service->writer()->write(uid, entry);
        std::cin.get();
    } catch ( const std::exception & e ) {
        std::cerr << "Exception: " << e.what() << std::endl;
        return -1;
    }
    return 0;
}


