package ru.yandex.base64;

import java.util.Arrays;

public enum Base64 {
    INSTANCE(true, defaultEncodeTable()),
    URL(false, urlEncodeTable());

    private final boolean pad;

    @SuppressWarnings("ImmutableEnumChecker")
    private final char[] encodeTable;

    @SuppressWarnings("ImmutableEnumChecker")
    private final byte[] decodeTable;

    @SuppressWarnings("ImmutableEnumChecker")
    private final byte[] minimalDecodeTable;

    Base64(final boolean pad, final char[] encodeTable) {
        this.pad = pad;
        this.encodeTable = encodeTable;
        decodeTable = createDecodeTable(encodeTable);
        minimalDecodeTable = trimDecodeTable(decodeTable);
    }

    public boolean pad() {
        return pad;
    }

    char[] encodeTable() {
        return encodeTable;
    }

    byte[] decodeTable() {
        return decodeTable;
    }

    byte[] minimalDecodeTable() {
        return minimalDecodeTable;
    }

    public static byte[] createDecodeTable(final char[] encodeTable) {
        final int decodeTableSize = 256;
        byte[] decodeTable = new byte[decodeTableSize];
        Arrays.fill(decodeTable, (byte) -1);
        for (int i = 0; i < encodeTable.length; ++i) {
            decodeTable[encodeTable[i]] = (byte) i;
        }
        return decodeTable;
    }

    public static byte[] trimDecodeTable(final byte[] decodeTable) {
        int size = decodeTable.length - 1;
        while (size >= 0 && decodeTable[size] == -1) {
            --size;
        }
        return Arrays.copyOf(decodeTable, size + 1);
    }

    private static char[] defaultEncodeTable() {
        return new char[] {
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',
            'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
            'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f',
            'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n',
            'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
            'w', 'x', 'y', 'z', '0', '1', '2', '3',
            '4', '5', '6', '7', '8', '9', '+', '/'
        };
    }

    private static char[] urlEncodeTable() {
        char[] encodeTable = defaultEncodeTable();
        encodeTable[encodeTable.length - 1] = '_';
        encodeTable[encodeTable.length - 2] = '-';
        return encodeTable;
    }
}

