package ru.yandex.base64;

import java.io.IOException;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.function.CharArrayVoidProcessor;

// Strict single line base64 decoder
public class Base64Decoder
    extends ByteArrayProcessable
    implements CharArrayVoidProcessor<IOException>
{
    private static final int SECOND_SHIFT = 4;
    private static final int SECOND_MASK = 15;
    private static final int THIRD_SHIFT = 6;
    private static final int THIRD_MASK = 3;

    private final byte[] decodeTable;

    public Base64Decoder() {
        this(Base64.INSTANCE);
    }

    public Base64Decoder(final Base64 base64) {
        decodeTable = base64.minimalDecodeTable();
    }

    private byte decodeChar(final char c) throws IOException {
        byte result;
        if (c >= decodeTable.length) {
            result = -1;
        } else {
            result = decodeTable[c];
        }
        if (result == -1) {
            throw new MalformedBase64Exception("Bad base64 character: " + c);
        }
        return result;
    }

    // CSOFF: FinalParameters
    @Override
    public void process(final char[] cbuf, int off, int len)
        throws IOException
    {
        if (len == 0) {
            this.len = 0;
            return;
        }
        while (len > 0 && cbuf[off + len - 1] == '=') {
            --len;
        }
        int rem = len & THIRD_MASK;
        this.len = (len >> 2) * THIRD_MASK;
        switch (rem) {
            case 0:
                break;
            case 1:
                throw new IncompleteBase64Exception();
            case 2:
                ++this.len;
                break;
            default:
                this.len += 2;
                break;
        }
        ensureBufCapacity(this.len);
        len -= rem;
        int threshold = off + len;
        int pos = 0;
        for (; off < threshold;) {
            byte b0 = decodeChar(cbuf[off++]);
            byte b1 = decodeChar(cbuf[off++]);
            byte b2 = decodeChar(cbuf[off++]);
            byte b3 = decodeChar(cbuf[off++]);
            buf[pos++] = (byte) ((b0 << 2) | (b1 >> SECOND_SHIFT));
            buf[pos++] =
                (byte) (((b1 & SECOND_MASK) << SECOND_SHIFT) | b2 >> 2);
            buf[pos++] = (byte) (((b2 & THIRD_MASK) << THIRD_SHIFT) | b3);
        }
        switch (rem) {
            case 0:
                break;
            case 2:
                buf[pos] = (byte) ((decodeChar(cbuf[off]) << 2)
                    | (decodeChar(cbuf[off + 1]) >> SECOND_SHIFT));
                break;
            default:
                byte b0 = decodeChar(cbuf[off++]);
                byte b1 = decodeChar(cbuf[off++]);
                byte b2 = decodeChar(cbuf[off]);
                buf[pos++] = (byte) ((b0 << 2) | (b1 >> SECOND_SHIFT));
                buf[pos] =
                    (byte) (((b1 & SECOND_MASK) << SECOND_SHIFT) | b2 >> 2);
                break;
        }
    }
    // CSON: FinalParameters
}

