package ru.yandex.base64;

import ru.yandex.function.ByteArrayVoidProcessor;
import ru.yandex.function.CharArrayProcessable;

public class Base64Encoder
    extends CharArrayProcessable
    implements ByteArrayVoidProcessor<RuntimeException>
{
    private static final int DIV = 3;
    private static final int MUL = 4;
    private static final int LAST_SHIFT = 6;
    private static final int MASK = 15;
    private static final int LAST_MASK = 63;
    private static final int BYTE_MASK = 0xff;

    private final char[] encodeTable;
    private final boolean pad;

    public Base64Encoder() {
        this(Base64.INSTANCE);
    }

    public Base64Encoder(final Base64 base64) {
        encodeTable = base64.encodeTable();
        pad = base64.pad();
    }

    @Override
    public void process(final byte[] buf, final int off, final int len) {
        if (pad) {
            this.len = ((len + 2) / DIV) * MUL;
        } else {
            this.len = len / DIV * MUL;
            switch (len % DIV) {
                case 1:
                    this.len += 2;
                    break;
                case 2:
                    this.len += DIV;
                    break;
                default:
                    break;
            }
        }
        ensureBufCapacity(this.len);
        int rem = len % DIV;
        int full = len - rem;
        int pos = 0;
        int i = 0;
        int b;
        int r;
        while (i < full) {
            b = buf[i++] & BYTE_MASK;
            this.buf[pos++] = encodeTable[b >> 2];
            r = (b & DIV) << MUL;
            b = buf[i++] & BYTE_MASK;
            this.buf[pos++] = encodeTable[r | (b >> MUL)];
            r = (b & MASK) << 2;
            b = buf[i++] & BYTE_MASK;
            this.buf[pos++] = encodeTable[r | (b >> LAST_SHIFT)];
            this.buf[pos++] = encodeTable[b & LAST_MASK];
        }

        switch (rem) {
            case 1:
                b = buf[i] & BYTE_MASK;
                this.buf[pos++] = encodeTable[b >> 2];
                this.buf[pos] = encodeTable[(b & DIV) << MUL];
                if (pad) {
                    this.buf[++pos] = '=';
                    this.buf[++pos] = '=';
                }
                break;

            case 2:
                b = buf[i++] & BYTE_MASK;
                this.buf[pos++] = encodeTable[b >> 2];
                r = (b & DIV) << MUL;
                b = buf[i] & BYTE_MASK;
                this.buf[pos++] = encodeTable[r | (b >> MUL)];
                this.buf[pos] = encodeTable[(b & MASK) << 2];
                if (pad) {
                    this.buf[++pos] = '=';
                }
                break;

            default:
                break;
        }
    }
}

