package ru.yandex.base64;

import java.io.IOException;
import java.io.InputStream;

import ru.yandex.io.DecodingInputStream;

public class Base64InputStream extends DecodingInputStream {
    private static final int BYTE_MASK = 0xff;
    private static final byte[] TABLE = Base64.INSTANCE.decodeTable();
    private int state = 0;
    private int value = 0;

    public Base64InputStream(final InputStream in) {
        super(in);
    }

    @Override
    protected void fillBuffer() throws IOException {
        buflen = in.read(buf);
        pos = 0;
        for (int i = 0; i < buflen; ++i) {
            byte b = TABLE[buf[i] & BYTE_MASK];
            if (b >= 0) {
                value <<= 6;
                value |= b;
                if (++state == 4) {
                    buf[pos++] = (byte) (value >> 16);
                    buf[pos++] = (byte) ((value >> 8) & BYTE_MASK);
                    buf[pos++] = (byte) (value & BYTE_MASK);
                    state = 0;
                    value = 0;
                }
            }
        }
        // For state == 1 our output can't outrun input position, so, this case
        // can be left as it is, we could decode data later.
        // For state == 1 at the end of input we simply drop this data, so we
        // don't output incomplete byte.
        // For state > 1 we should read rest of 4-character group and output
        // decoded bytes.
        if ((state > 1 || pos == 0) && buflen != -1) {
            while (state < 4) {
                int r = in.read();
                if (r == -1) {
                    break;
                }
                byte b = TABLE[r];
                if (b >= 0) {
                    value <<= 6;
                    value |= b;
                    ++state;
                }
            }
            switch (state) {
                case 2:
                    buf[pos++] = (byte) (value >> 4);
                    break;
                case 3:
                    buf[pos++] = (byte) (value >> 10);
                    buf[pos++] = (byte) ((value >> 2) & BYTE_MASK);
                    break;
                default:
                    buf[pos++] = (byte) (value >> 16);
                    buf[pos++] = (byte) ((value >> 8) & BYTE_MASK);
                    buf[pos++] = (byte) (value & BYTE_MASK);
                    value = 0;
                    break;
            }
            state = 0;
        }
        buflen = pos;
        pos = 0;
    }
}

