package ru.yandex.base64;

import java.io.IOException;

import ru.yandex.function.ByteArrayCopier;
import ru.yandex.function.GenericFunction;

public enum Base64Parser
    implements GenericFunction<String, byte[], IOException>
{
    INSTANCE(Base64.INSTANCE),
    URL(Base64.URL);

    private final Base64 base64;

    Base64Parser(final Base64 base64) {
        this.base64 = base64;
    }

    @Override
    public byte[] apply(final String str) throws IOException {
        Base64Decoder decoder = new Base64Decoder(base64);
        decoder.process(str.toCharArray());
        return decoder.processWith(ByteArrayCopier.INSTANCE);
    }
}

