package ru.yandex.charset;

import java.nio.charset.CharacterCodingException;

import sun.nio.cs.ArrayDecoder;

public class ArrayByteDecoder implements ByteDecoder {
    private final ArrayDecoder decoder;

    public ArrayByteDecoder(final ArrayDecoder decoder) {
        this.decoder = decoder;
    }

    // CSOFF: ParameterNumber
    @Override
    public int decode(
        final byte[] buf,
        final int off,
        final int len,
        final char[] cbuf)
        throws CharacterCodingException
    {
        int decoded = decoder.decode(buf, off, len, cbuf);
        if (decoded == -1) {
            throw new CharacterCodingException();
        }
        return decoded;
    }
    // CSON: ParameterNumber
}

