package ru.yandex.charset;

import java.nio.charset.CharacterCodingException;

import sun.nio.cs.ArrayEncoder;

public class ArrayByteEncoder implements ByteEncoder {
    private final ArrayEncoder encoder;

    public ArrayByteEncoder(final ArrayEncoder encoder) {
        this.encoder = encoder;
    }

    // CSOFF: ParameterNumber
    @Override
    public int encode(
        final char[] cbuf,
        final int off,
        final int len,
        final byte[] buf)
        throws CharacterCodingException
    {
        int encoded = encoder.encode(cbuf, off, len, buf);
        if (encoded == -1) {
            throw new CharacterCodingException();
        }
        return encoded;
    }
    // CSON: ParameterNumber
}

