package ru.yandex.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class BufferByteDecoder implements ByteDecoder {
    private static final int MAX_BUF_CAPACITY = 32768;
    private static final int MAX_CBUF_CAPACITY = 16384;

    private final CharsetDecoder decoder;
    private ByteBuffer bb = null;
    private byte[] lastBuf = null;
    private CharBuffer cb = null;
    private char[] lastCBuf = null;

    public BufferByteDecoder(final CharsetDecoder decoder) {
        this.decoder = decoder;
    }

    // CSOFF: ParameterNumber
    @Override
    public int decode(
        final byte[] buf,
        final int off,
        final int len,
        final char[] cbuf)
        throws CharacterCodingException
    {
        decoder.reset();
        ByteBuffer bb;
        if (buf == lastBuf) {
            bb = this.bb;
            bb.limit(off + len);
            bb.position(off);
        } else {
            bb = ByteBuffer.wrap(buf, off, len);
            if (buf.length <= MAX_BUF_CAPACITY) {
                this.bb = bb;
                lastBuf = buf;
            }
        }
        CharBuffer cb;
        if (cbuf == lastCBuf) {
            cb = this.cb;
            cb.limit(cbuf.length);
            cb.position(0);
        } else {
            cb = CharBuffer.wrap(cbuf);
            if (cbuf.length <= MAX_CBUF_CAPACITY) {
                this.cb = cb;
                lastCBuf = cbuf;
            }
        }
        CoderResult result = decoder.decode(bb, cb, true);
        if (result.isError()) {
            result.throwException();
        }
        return cb.position();
    }
    // CSON: ParameterNumber
}

