package ru.yandex.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class BufferByteEncoder implements ByteEncoder {
    private static final int MAX_BUF_CAPACITY = 32768;
    private static final int MAX_CBUF_CAPACITY = 16384;

    private final CharsetEncoder encoder;
    private ByteBuffer bb = null;
    private byte[] lastBuf = null;
    private CharBuffer cb = null;
    private char[] lastCBuf = null;

    public BufferByteEncoder(final CharsetEncoder encoder) {
        this.encoder = encoder;
    }

    // CSOFF: ParameterNumber
    @Override
    public int encode(
        final char[] cbuf,
        final int off,
        final int len,
        final byte[] buf)
        throws CharacterCodingException
    {
        encoder.reset();
        CharBuffer cb;
        if (cbuf == lastCBuf) {
            cb = this.cb;
            cb.limit(off + len);
            cb.position(off);
        } else {
            cb = CharBuffer.wrap(cbuf, off, len);
            if (cbuf.length <= MAX_CBUF_CAPACITY) {
                this.cb = cb;
                lastCBuf = cbuf;
            }
        }
        ByteBuffer bb;
        if (buf == lastBuf) {
            bb = this.bb;
            bb.limit(buf.length);
            bb.position(0);
        } else {
            bb = ByteBuffer.wrap(buf);
            if (buf.length <= MAX_BUF_CAPACITY) {
                this.bb = bb;
                lastBuf = buf;
            }
        }
        CoderResult result = encoder.encode(cb, bb, true);
        if (result.isError()) {
            result.throwException();
        }
        return bb.position();
    }
    // CSON: ParameterNumber
}

