package ru.yandex.charset;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;

import sun.nio.cs.ArrayDecoder;

import ru.yandex.function.ByteArrayVoidProcessor;
import ru.yandex.function.CharArrayProcessable;

public class Decoder
    extends CharArrayProcessable
    implements ByteArrayVoidProcessor<CharacterCodingException>
{
    private final double maxCharsPerByte;
    private final ByteDecoder decoder;

    public Decoder(final Charset charset) {
        this(charset, CodingErrorAction.REPORT);
    }

    public Decoder(
        final Charset charset,
        final CodingErrorAction errorAction)
    {
        this(
            charset.newDecoder()
                .onMalformedInput(errorAction)
                .onUnmappableCharacter(errorAction));
    }

    public Decoder(final CharsetDecoder decoder) {
        maxCharsPerByte = decoder.maxCharsPerByte();
        if (decoder instanceof ArrayDecoder) {
            this.decoder = new ArrayByteDecoder((ArrayDecoder) decoder);
        } else {
            this.decoder = new BufferByteDecoder(decoder);
        }
    }

    public void decode(final byte[] buf) throws CharacterCodingException {
        process(buf);
    }

    public void decode(final byte[] buf, final int off, final int len)
        throws CharacterCodingException
    {
        process(buf, off, len);
    }

    @Override
    public void process(final byte[] buf, final int off, final int len)
        throws CharacterCodingException
    {
        ensureBufCapacity(((int) (len * maxCharsPerByte)) + 1);
        this.len = decoder.decode(buf, off, len, this.buf);
    }

    public String toString(final byte[] buf, final int off, final int len)
        throws CharacterCodingException
    {
        char[] cbuf = new char[((int) (len * maxCharsPerByte)) + 1];
        return new String(cbuf, 0, decoder.decode(buf, off, len, cbuf));
    }
}

