package ru.yandex.charset;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import sun.nio.cs.ArrayEncoder;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.function.CharArrayVoidProcessor;

public class Encoder
    extends ByteArrayProcessable
    implements CharArrayVoidProcessor<CharacterCodingException>
{
    private final double maxBytesPerChar;
    private final ByteEncoder encoder;

    public Encoder(final Charset charset) {
        this(charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPORT)
            .onUnmappableCharacter(CodingErrorAction.REPORT));
    }

    public Encoder(final CharsetEncoder encoder) {
        maxBytesPerChar = encoder.maxBytesPerChar();
        if (encoder instanceof ArrayEncoder) {
            this.encoder = new ArrayByteEncoder((ArrayEncoder) encoder);
        } else {
            this.encoder = new BufferByteEncoder(encoder);
        }
    }

    @Override
    public void process(final char[] buf, final int off, final int len)
        throws CharacterCodingException
    {
        ensureBufCapacity(((int) (len * maxBytesPerChar)) + 1);
        this.len = encoder.encode(buf, off, len, this.buf);
    }
}

