package ru.yandex.charset;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Set;

public class FilterCharset extends Charset {
    private final Charset charset;

    public FilterCharset(final Charset charset) {
        this(charset.name(), charset.aliases(), charset);
    }

    public FilterCharset(
        final String canonicalName,
        final Set<String> aliases,
        final Charset charset)
    {
        super(canonicalName, aliases.toArray(new String[aliases.size()]));
        this.charset = charset;
    }

    @Override
    public boolean contains(final Charset charset) {
        return this.charset.contains(charset);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return charset.newDecoder();
    }

    @Override
    public CharsetEncoder newEncoder() {
        return charset.newEncoder();
    }
}

