package ru.yandex.cityhash;

import java.io.ByteArrayOutputStream;

import at.orz.hash.CityHash;

public class CityHashingArrayOutputStream extends ByteArrayOutputStream {
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final int THEADER_SIZE = INT_SIZE + LONG_SIZE;

    public CityHashingArrayOutputStream() {
        super();
    }

    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    @Override
    public byte[] toByteArray() {
        long hash = CityHash.yandexCityHash64(buf, 0, count);
        byte[] data = new byte[count + LONG_SIZE];
        writeLong(hash, data, 0);
        System.arraycopy(buf, 0, data, LONG_SIZE, count);
        return data;
    }

    public byte[] toByteArrayWithVersion(final int version) {
        long hash = CityHash.yandexCityHash64(buf, 0, count);
        byte[] data = new byte[count + THEADER_SIZE];
        writeInt(version, data, 0);
        writeLong(hash, data, INT_SIZE);
        System.arraycopy(buf, 0, data, THEADER_SIZE, count);
        return data;
    }

    public long yandexCityHash() {
        return CityHash.yandexCityHash64(buf, 0, count);
    }

    public long cityHash() {
        return CityHash.cityHash64(buf, 0, count);
    }

    //CSOFF: MagicNumber
    private void writeLong(final long l, final byte[] out, final int off) {
        out[off] = (byte) (l & 0xFF);
        out[off + 1] = (byte) ((l >> 8) & 0xFF);
        out[off + 2] = (byte) ((l >> 16) & 0xFF);
        out[off + 3] = (byte) ((l >> 24) & 0xFF);
        out[off + 4] = (byte) ((l >> 32) & 0xFF);
        out[off + 5] = (byte) ((l >> 40) & 0xFF);
        out[off + 6] = (byte) ((l >> 48) & 0xFF);
        out[off + 7] = (byte) ((l >> 56) & 0xFF);
    }

    private void writeInt(final int i, final byte[] out, final int off) {
        out[off] = (byte) (i & 0xFF);
        out[off + 1] = (byte) ((i >> 8) & 0xFF);
        out[off + 2] = (byte) ((i >> 16) & 0xFF);
        out[off + 3] = (byte) ((i >> 24) & 0xFF);
    }
    //CSON: MagicNumber
}
