package ru.yandex.collection;

import java.util.Arrays;
import java.util.PrimitiveIterator;

public class BinaryTrieSet {
    private static final int NODE_SIZE = 3;
    private static final int INITIAL_NODES_CAPACITY = 512;

    private int[] data = new int[NODE_SIZE * INITIAL_NODES_CAPACITY];
    private int nodes = NODE_SIZE;

    public boolean add(final PrimitiveIterator.OfInt bits) {
        return add(bits, 0);
    }

    private boolean add(final PrimitiveIterator.OfInt bits, final int pos) {
        if (bits.hasNext()) {
            int nodeIndex = pos + bits.nextInt();
            int next = data[nodeIndex];
            if (next == 0) {
                data[nodeIndex] = nodes;
                next = nodes;
                if (nodes >= data.length) {
                    data = Arrays.copyOf(
                        data,
                        ((nodes + (nodes >>> 1)) / NODE_SIZE + 1) * NODE_SIZE);
                }
                nodes += NODE_SIZE;
            }
            return add(bits, next);
        } else {
            int dataIndex = pos + 2;
            boolean result;
            if (data[dataIndex] == 0) {
                result = true;
                data[dataIndex] = 1;
            } else {
                result = false;
            }
            return result;
        }
    }

    public boolean contains(final PrimitiveIterator.OfInt bits) {
        return contains(bits, 0);
    }

    // CSOFF: ReturnCount
    private boolean contains(
        final PrimitiveIterator.OfInt bits,
        final int pos)
    {
        if (bits.hasNext()) {
            int next = data[pos + bits.nextInt()];
            if (next == 0) {
                return false;
            } else {
                return contains(bits, next);
            }
        } else {
            return data[pos + 2] != 0;
        }
    }
    // CSON: ReturnCount

    public boolean containsPrefix(final PrimitiveIterator.OfInt bits) {
        return containsPrefix(bits, 0);
    }

    // CSOFF: ReturnCount
    private boolean containsPrefix(
        final PrimitiveIterator.OfInt bits,
        final int pos)
    {
        int value = data[pos + 2];
        if (value == 0) {
            if (bits.hasNext()) {
                int next = data[pos + bits.nextInt()];
                if (next == 0) {
                    return false;
                } else {
                    return containsPrefix(bits, next);
                }
            } else {
                return false;
            }
        } else {
            return true;
        }
    }
    // CSON: ReturnCount

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodes;) {
            sb.append('(');
            sb.append(i);
            sb.append(')');
            sb.append('[');
            sb.append(data[i++]);
            sb.append(',');
            sb.append(data[i++]);
            sb.append(',');
            sb.append(data[i++] == 1);
            sb.append(']');
            sb.append(' ');
        }
        sb.setLength(sb.length() - 1);
        return new String(sb);
    }
}

