package ru.yandex.collection;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingBlockingQueue<E>
    extends FilterBlockingQueue<E, BlockingQueue<E>>
{
    public BlockingBlockingQueue(final BlockingQueue<E> q) {
        super(q);
    }

    @Override
    public boolean offer(final E e) {
        try {
            put(e);
        } catch (InterruptedException ex) {
            return false;
        }
        return true;
    }

    @Override
    public boolean offer(final E e, final long timeout, final TimeUnit unit)
        throws InterruptedException
    {
        put(e);
        return true;
    }
}
