package ru.yandex.collection;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class ByteArrayBitIterator implements PrimitiveIterator.OfInt {
    private static final int BITS_BITS = 3;
    private static final int BITS_MASK = (1 << BITS_BITS) - 1;

    private final byte[] data;
    private final int end;
    private int pos = 0;

    public ByteArrayBitIterator(final byte[] data) {
        this(data, 0, data.length << BITS_BITS);
    }

    public ByteArrayBitIterator(
        final byte[] data,
        final int off,
        final int len)
    {
        this.data = data;
        end = off + len;
        pos = off;
    }

    @Override
    public boolean hasNext() {
        return pos < end;
    }

    @Override
    public int nextInt() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        int bit =
            (data[pos >>> BITS_BITS] >>> (BITS_MASK - (pos & BITS_MASK))) & 1;
        ++pos;
        return bit;
    }
}

