package ru.yandex.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionCompactor {
    private CollectionCompactor() {
    }

    public static <T> Set<T> compact(final Set<T> set) {
        Set<T> result;
        switch (set.size()) {
            case 0:
                result = Collections.emptySet();
                break;
            case 1:
                result = Collections.singleton(set.iterator().next());
                break;
            default:
                result = set;
                break;
        }
        return result;
    }

    public static <T> List<T> compact(final List<T> list) {
        List<T> result;
        switch (list.size()) {
            case 0:
                result = Collections.emptyList();
                break;
            case 1:
                result = Collections.singletonList(list.get(0));
                break;
            default:
                result = list;
                break;
        }
        return result;
    }

    public static <T> List<T> compactOrCopy(final List<T> list) {
        List<T> result;
        switch (list.size()) {
            case 0:
                result = Collections.emptyList();
                break;
            case 1:
                result = Collections.singletonList(list.get(0));
                break;
            default:
                result = new ArrayList<>(list);
                break;
        }
        return result;
    }

    public static <K, V> Map<K, V> compact(final Map<K, V> map) {
        Map<K, V> result;
        switch (map.size()) {
            case 0:
                result = Collections.emptyMap();
                break;
            case 1:
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                result = new SingletonMap<>(entry.getKey(), entry.getValue());
                break;
            default:
                result = map;
                break;
        }
        return result;
    }
}

