package ru.yandex.collection;

import javax.annotation.Nonnull;

public class ComparableLongPair<T extends Comparable<T>>
    extends LongPair<T>
    implements Comparable<ComparableLongPair<T>>
{
    public ComparableLongPair(final long first, @Nonnull final T second) {
        super(first, second);
    }

    @Override
    public int compareTo(final ComparableLongPair<T> other) {
        int cmp = Long.compare(first, other.first);
        if (cmp == 0) {
            cmp = second.compareTo(other.second);
        }
        return cmp;
    }
}

