package ru.yandex.collection;

public final class DoublePair<T> {
    private final double first;
    private final T second;

    public DoublePair(final double first, final T second) {
        this.first = first;
        this.second = second;
    }

    public double first() {
        return first;
    }

    public T second() {
        return second;
    }

    @Override
    public String toString() {
        return '[' + Double.toString(first) + ',' + second + ']';
    }
}

