package ru.yandex.collection;

import java.util.BitSet;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

public class EmptyIntSet implements IntSet {
    public static final EmptyIntSet INSTANCE = new EmptyIntSet();
    public static final PrimitiveIterator.OfInt ITERATOR =
        new PrimitiveIterator.OfInt() {
            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public int nextInt() {
                throw new NoSuchElementException();
            }

            @Override
            public Integer next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new IllegalStateException();
            }
        };

    protected EmptyIntSet() {
    }

    @Override
    public int min() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int max() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean contains(final int value) {
        return false;
    }

    @Override
    public PrimitiveIterator.OfInt iterator() {
        return ITERATOR;
    }

    @Override
    public BitSet toBitSet() {
        return new BitSet(0);
    }
}

