package ru.yandex.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

import ru.yandex.function.StringBuilderable;

public class EmptyMap<K, V> implements Map<K, V>, StringBuilderable {
    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsKey(final Object key) {
        return false;
    }

    @Override
    public boolean containsValue(final Object value) {
        return false;
    }

    @Override
    public V get(final Object key) {
        return null;
    }

    @Override
    public V getOrDefault(final Object key, final V defaultValue) {
        return defaultValue;
    }

    @Override
    public V remove(final Object key) {
        return null;
    }

    @Override
    public V put(final K key, final V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return Collections.emptySet();
    }

    @Override
    public Collection<V> values() {
        return Collections.emptySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.emptySet();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(final Object o) {
        return this == o || (o instanceof Map && ((Map<?, ?>) o).isEmpty());
    }

    @Override
    public String toString() {
        return "{}";
    }

    @Override
    public void toStringBuilder(final StringBuilder sb) {
        sb.append(toString());
    }
}

