package ru.yandex.collection;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class EqualableIdentityHashMap<K, V> extends IdentityHashMap<K, V> {
    private static final long serialVersionUID = 0;

    public EqualableIdentityHashMap() {
    }

    public EqualableIdentityHashMap(final int expectedMaxSize) {
        super(expectedMaxSize);
    }

    public EqualableIdentityHashMap(final Map<K, V> map) {
        super(map);
    }

    @Override
    public int hashCode() {
        // IdentityHashMap.hashCode() implementation differs from
        // AbstractMap.hashCode() implementation, so we have to reimplement it
        int h = 0;
        for (Entry<K, V> entry: entrySet()) {
            h += entry.hashCode();
        }
        return h;
    }

    // CSOFF: ReturnCount
    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof Map)) {
            return false;
        }

        Map<?, ?> other = (Map<?, ?>) o;
        if (size() != other.size()) {
            return false;
        }

        try {
            Iterator<Entry<K, V>> iter = entrySet().iterator();
            while (iter.hasNext()) {
                Entry<K, V> entry = iter.next();
                K key = entry.getKey();
                V value = entry.getValue();
                Object otherValue = other.get(key);
                if (value == null) {
                    if (otherValue != null || !other.containsKey(key)) {
                        return false;
                    }
                } else if (!value.equals(otherValue)) {
                    return false;
                }
            }
        } catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return true;
    }
    // CSON: ReturnCount
}

