package ru.yandex.collection;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class FilterBlockingQueue<E, Q extends BlockingQueue<E>>
    extends FilterQueue<E, Q>
    implements BlockingQueue<E>
{
    public FilterBlockingQueue(final Q q) {
        super(q);
    }

    @Override
    public int drainTo(final Collection<? super E> c) {
        return this.c.drainTo(c);
    }

    @Override
    public int drainTo(final Collection<? super E> c, final int maxElements) {
        return this.c.drainTo(c, maxElements);
    }

    @Override
    public boolean offer(final E e, final long timeout, final TimeUnit unit)
        throws InterruptedException
    {
        return c.offer(e, timeout, unit);
    }

    @Override
    public E poll(final long timeout, final TimeUnit unit)
        throws InterruptedException
    {
        return c.poll(timeout, unit);
    }

    @Override
    public void put(final E e) throws InterruptedException {
        c.put(e);
    }

    @Override
    public int remainingCapacity() {
        return c.remainingCapacity();
    }

    @Override
    public E take() throws InterruptedException {
        return c.take();
    }
}
