package ru.yandex.collection;

import java.util.Collection;
import java.util.Iterator;

public class FilterCollection<E, C extends Collection<E>>
    implements Collection<E>
{
    protected final C c;

    public FilterCollection(final C c) {
        this.c = c;
    }

    @Override
    public boolean add(final E e) {
        return c.add(e);
    }

    @Override
    public boolean addAll(final Collection<? extends E> c) {
        return this.c.addAll(c);
    }

    @Override
    public void clear() {
        c.clear();
    }

    @Override
    public boolean contains(final Object o) {
        return c.contains(o);
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        return this.c.containsAll(c);
    }

    @Override
    @SuppressWarnings("UndefinedEquals")
    public boolean equals(final Object o) {
        return c.equals(o);
    }

    @Override
    public int hashCode() {
        return c.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return c.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return c.iterator();
    }

    @Override
    public boolean remove(final Object o) {
        return c.remove(o);
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        return this.c.removeAll(c);
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        return this.c.retainAll(c);
    }

    @Override
    public int size() {
        return c.size();
    }

    @Override
    public Object[] toArray() {
        return c.toArray();
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T> T[] toArray(final T[] a) {
        return c.toArray(a);
    }
}
