package ru.yandex.collection;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

public class FilterList<E, L extends List<E>>
    extends FilterCollection<E, L>
    implements List<E>
{
    public FilterList(final L list) {
        super(list);
    }

    @Override
    public void add(final int index, final E element) {
        c.add(index, element);
    }

    @Override
    public boolean addAll(final int index, final Collection<? extends E> c) {
        return this.c.addAll(index, c);
    }

    @Override
    public E get(final int index) {
        return c.get(index);
    }

    @Override
    public int indexOf(final Object o) {
        return c.indexOf(o);
    }

    @Override
    public int lastIndexOf(final Object o) {
        return c.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return c.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return c.listIterator(index);
    }

    @Override
    public E remove(final int index) {
        return c.remove(index);
    }

    @Override
    public E set(final int index, final E element) {
        return c.set(index, element);
    }

    @Override
    public List<E> subList(final int fromIndex, final int toIndex) {
        return c.subList(fromIndex, toIndex);
    }
}

