package ru.yandex.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class FilterMap<K, V, M extends Map<K, V>> implements Map<K, V> {
    protected final M m;

    public FilterMap(final M m) {
        this.m = m;
    }

    @Override
    public void clear() {
        m.clear();
    }

    @Override
    public boolean containsKey(final Object key) {
        return m.containsKey(key);
    }

    @Override
    public boolean containsValue(final Object value) {
        return m.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return m.entrySet();
    }

    @Override
    public boolean equals(final Object o) {
        return m.equals(o);
    }

    @Override
    public V get(final Object key) {
        return m.get(key);
    }

    @Override
    public int hashCode() {
        return m.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return m.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return m.keySet();
    }

    @Override
    public V put(final K key, final V value) {
        return m.put(key, value);
    }

    @Override
    public void putAll(final Map<? extends K, ? extends V> m) {
        this.m.putAll(m);
    }

    @Override
    public V putIfAbsent(final K key, final V value) {
        return m.putIfAbsent(key, value);
    }

    @Override
    public V remove(final Object key) {
        return m.remove(key);
    }

    @Override
    public int size() {
        return m.size();
    }

    @Override
    public Collection<V> values() {
        return m.values();
    }
}

